scenario = "report";
# This is the game of 'Worm' implemented in Neurobs Presentation.
# Running this game will measure the reaction of people to faulty
# computer game controls.

# todo: use force measuring controls 
#
# (C) 2012 Wilbert van Ham, Radboud University Nijmegen, Faculty of Social Sciences

response_matching = simple_matching;
active_buttons = 4; # make sure the arrow keys are activated in 'settings'

begin;
trial{
	trial_type = first_response;
	trial_duration = forever;
	
	picture {
		text {
			font = "sans"; # any sans
			caption = "Use arrow keys to control experiment.\n Continue as long as possible.\nUse up-arrow to start.";
			font_size = 36;
		};
		x = 0; y = 0;
	};
	target_button = 1;
} instructions;

trial{
	trial_type = first_response;
	trial_duration = forever;
	
	picture {
		text {
			font = "sans"; # any sans
			caption = "The experiment has ended.\n Thank you for participating.\n Please participate again and help the advancement of science.";
			font_size = 36;
		};
		x = 0; y = 0;
	};
	target_button = 1,2,3,4;
} endOfGame;

sound{
	wavefile {filename = "sound/lark.wav"; preload = true;};
} foodSound;

sound{
	wavefile {filename = "sound/steer.wav"; preload = true;};
} wallSound;


box {height = 20; width = 20; color = 255,128,128; } worm;
box {height = 15; width = 15; color = 255,0,0; } wall;
box {height = 20; width = 20; color = 0,255,0; } grass;
box {height = 20; width = 20; color = 0,0,255; } food;

picture{
	#text {
		#font = "sans"; # any sans
		#caption = "LOG";
		#font_size = 36;
		#text_align = align_left;
	#} log1;
	#x = -400; y = 400;

	text {
		font = "sans"; # any sans
		caption = "0";
		font_size = 36;
		text_align = align_right;
	} scoreLog;	
	x = -400; y = 450;
} pic;


begin_pcl;

#include "empty.pcl";

instructions.present();

## constants
int EMPTY = 0;
int WALL  = 1;
int WORM  = 2;
int FOOD  = 3;
int GRASS = 4;

## variables
array <int> dir[2] = {0,1};
int score = 0;
int minWormLength = 5;
int maxWormLength = 20;
int wormLength = minWormLength;
int nFood=5;
int unitSize = 25; # pixels per block
array <int> gridSize[2] = {31, 15};
array <double> offset[2]; # offset from cell indices (1-gridSize) to coordinates (zero centered)
	offset[1] = (double(gridSize[1])+1.0)/2.0;
	offset[2] = (double(gridSize[2])+1.0)/2.0; 
array <int> gridContent[gridSize[1]][gridSize[2]];
array <int> gridPart[gridSize[1]][gridSize[2]]; # which picture part is on this position
array <int> wormPart[maxWormLength]; # which picture part is this worm part
array <int> wormXy[maxWormLength][2]; 

## subroutines
sub outputPrint(string str) begin
	# print output to log
	output_file ofile = new output_file;
	ofile.open_append("worm.log");
	ofile.print(date_time("yyyy-mm-dd hh:mm:ss: ") + str +"\n");
	ofile.close();
end;

sub int ix2x(int ix) begin
	# convert index x (1-gridSize[1]) to screen x 
	return int(double(unitSize)*(double(ix)-offset[1]))
end;

sub int iy2y(int iy) begin
	# convert index y (1-gridSize[2]) to screen y 
	return int(double(unitSize)*(double(iy)-offset[2]))
end;



# setup worm
loop
	int i = 1;
until
	i>wormLength
begin
	wormXy[i][1] = gridSize[1]/2+1;
	wormXy[i][2] = wormLength+1-i;
	pic.add_part(worm, 0, ix2x(wormXy[i][2]));
	# gridPart[wormXy[i][1]][wormXy[i][2]] = pic.part_count(); # already stored in wormPart
	gridContent[wormXy[i][1]][wormXy[i][2]] = WORM;
	wormPart[i] = pic.part_count();
	pic.set_part_on_top(wormPart[i], true);
	i = i + 1;
end;

# setup wall
loop
	int i = -gridSize[1]/2;
until
	i > gridSize[1]/2
begin
	pic.add_part(wall, unitSize*i, -unitSize*(gridSize[2]/2+1));
	pic.add_part(wall, unitSize*i, unitSize*(gridSize[2]/2+1));
	i = i + 1;
end;
loop
	int i = -gridSize[2]/2;
until
	i > gridSize[2]/2
begin
	pic.add_part(wall, -unitSize*(gridSize[1]/2+1), unitSize*i);
	pic.add_part(wall, unitSize*(gridSize[1]/2+1), unitSize*i);
	i = i + 1;
end;

# setup food
loop
	int i = 1;
until
	i > nFood
begin
	int x,y;
	loop
		x = random(1, gridSize[1]);
		y = random(1, gridSize[2]);
	until 
		gridContent[x][y] == EMPTY
	begin
		x = random(1, gridSize[1]);
		y = random(1, gridSize[2]);
	end;
	gridContent[x][y] = FOOD;
	pic.add_part(food, int(double(unitSize)*(double(x)-offset[1])), int(double(unitSize)*(double(y)-offset[2])));
	gridPart[x][y] = pic.part_count();

	i = i + 1;
end;

int processedHits = 0; # number of key presses
## main event loop
loop # main event loop
until
	1==0
begin
	# check response
	if (processedHits < response_manager.response_count()) then
		processedHits = processedHits + 1;
		response_data hit = response_manager.get_response_data(processedHits);	
		if processedHits == response_manager.response_count() && random(1,100)==1 then
			# only one unprocessed hit, 1% chance : ignore key
			outputPrint("ignored: "+string(hit.code())+" "+string(hit.time()));
		else
			#log1.set_caption("response: " + string(hit.button()));
			if hit.button()==1 then
				dir[1] = 0; dir[2] = 1; # up
			elseif hit.button()==2 then
				dir[1] = -1; dir[2] = 0; # left
			elseif hit.button()==3 then
				dir[1] = 1; dir[2] = 0; # right
			elseif hit.button()==4 then
				dir[1] = 0; dir[2] = -1; # down
			end;		
		end;
	end;
	

	# move worm body
	array <int> oldWormBack[2]; oldWormBack[1] = wormXy[wormLength][1]; oldWormBack[2] = wormXy[wormLength][2];
	gridContent[wormXy[wormLength][1]][wormXy[wormLength][2]] = EMPTY; # worm back
	loop
		int i = wormLength;
	until
		i==1
	begin
		wormXy[i][1] = wormXy[i-1][1];
		wormXy[i][2] = wormXy[i-1][2];
		pic.set_part_x(wormPart[i], ix2x(wormXy[i][1]));
		pic.set_part_y(wormPart[i], iy2y(wormXy[i][2]));
		i = i - 1;
	end;
	# move worm front
	wormXy[1][1] = wormXy[1][1]+dir[1];
	wormXy[1][2] = wormXy[1][2]+dir[2];
	pic.set_part_x(wormPart[1], ix2x(wormXy[1][1]));
	pic.set_part_y(wormPart[1], iy2y(wormXy[1][2]));

	# check where worm head has landed
	if wormXy[1][1]==0 || wormXy[1][1]>gridSize[1] || wormXy[1][2]==0 || wormXy[1][2]>gridSize[2] then #outer wall
		wallSound.present();
		break;
	elseif gridContent[wormXy[1][1]][wormXy[1][2]]==WALL || gridContent[wormXy[1][1]][wormXy[1][2]]==WORM then # inner wall or own tail
		# the whole list of 'or'ed conditionals is evaluated at once, risk of index out of bounds
		wallSound.present();
		break;
	elseif gridContent[wormXy[1][1]][wormXy[1][2]]==FOOD then
		#log1.set_caption("hit: food");
		score=score+1; scoreLog.set_caption(string(score));
		foodSound.present();
		gridContent[wormXy[1][1]][wormXy[1][2]] = WORM;
		
		# increase length of worm at back
		wormLength = wormLength+1;
		wormXy[wormLength][1] = oldWormBack[1];
		wormXy[wormLength][2] = oldWormBack[2];
		pic.add_part(worm, ix2x(oldWormBack[1]), iy2y(oldWormBack[2]));
		gridContent[wormXy[wormLength][1]][wormXy[wormLength][2]] = WORM;
		wormPart[wormLength] = pic.part_count();
		pic.set_part_on_top(wormPart[wormLength], true);
		
		# break off back of worm and make it a wall
		if wormLength == maxWormLength then
			loop
				int i = 1 + minWormLength;
			until
				i>maxWormLength
			begin
				gridContent[wormXy[i][1]][wormXy[i][2]] = WALL;
				gridPart[wormXy[i][1]][wormXy[i][2]] = wormPart[i];
				pic.set_part(wormPart[i], wall);
				i = i + 1;
			end;
			wormLength = minWormLength;
		end;
		
		
		# move food
		int x,y;
		loop
			x = random(1, gridSize[1]);
			y = random(1, gridSize[2]);
		until 
			gridContent[x][y] == EMPTY
		begin
			x = random(1, gridSize[1]);
			y = random(1, gridSize[2]);
		end;
		
		gridContent[x][y] = FOOD;
		gridPart[x][y] = gridPart[wormXy[1][1]][wormXy[1][2]];
		gridPart[wormXy[1][1]][wormXy[1][2]] = 0; # not necessary, gridParts without gridContent are never used
		
		pic.set_part_x(gridPart[x][y], ix2x(x));	
		pic.set_part_y(gridPart[x][y], iy2y(y));	
	end;
	
	#log1.redraw();
	scoreLog.redraw();
	pic.present();
	
	#if score==35 then
		#display_device.screenshot("screenshot.png");
	#end;
	wait_interval(100);
end;

endOfGame.present();
